/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing;

import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.presenter.ScannerPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.FillDatabaseTask;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.FillDatabaseTaskExecutor;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.GlobalSwingContext;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.MainWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.MessageBoxUtil;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.ProgressWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.language.LanguageDisplayFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;

public class FillDatabaseWindow
extends JDialog
implements ActionListener {
    private final ScannerPresenter presenter;
    private final Language language;
    private final Map<String, String> messages;
    private final Set<String> databases;
    private final String currentDatabase;
    private final Set<String> machines;
    private final boolean rightToLeft;
    private final Component mainWindow;
    private JList<Object> directoriesList;
    private DefaultListModel<Object> directoriesListModel;
    private JButton addDirectoryButton;
    private JButton removeDirectoryButton;
    private JCheckBox searchSubdirectoriesCheckBox;
    private JRadioButton existingDatabaseRadioButton;
    private JComboBox<String> existingDatabasesComboBox;
    private JRadioButton newDatabaseRadioButton;
    private JTextField newDatabaseTextField;
    private JLabel addModeLabel;
    private JComboBox<String> addModesComboBox;
    private JComboBox<String> profileNamesComboBox;
    private JCheckBox backupDatabaseCheckBox;
    private JCheckBox searchROMCheckBox;
    private JCheckBox searchDiskCheckBox;
    private JCheckBox searchTapeCheckBox;
    private JCheckBox searchLaserdiscCheckBox;
    private JComboBox<String> machinesComboBox;
    private JButton okButton;
    private JButton cancelButton;
    private static File previousSelectedDirectory;

    public FillDatabaseWindow(ScannerPresenter presenter, Language language, Set<String> databases, String currentDatabase, Set<String> machines, boolean rightToLeft) {
        this.presenter = presenter;
        this.language = language;
        this.databases = databases;
        this.currentDatabase = currentDatabase;
        this.machines = machines;
        this.rightToLeft = rightToLeft;
        this.mainWindow = GlobalSwingContext.getIntance().getMainWindow();
        this.messages = LanguageDisplayFactory.getDisplayMessages(this.getClass(), language);
    }

    public void display() {
        this.setDefaultCloseOperation(2);
        this.setTitle(this.messages.get("FILL_DATABASE"));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        if (this.rightToLeft) {
            this.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        JPanel contentPanel = new JPanel();
        this.getContentPane().setLayout(new BorderLayout());
        contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)contentPanel, "Center");
        JPanel directoriesPanel = new JPanel();
        directoriesPanel.setBorder(BorderFactory.createTitledBorder(this.messages.get("DIRECTORIES")));
        JPanel databaseOptionsPanel = new JPanel();
        databaseOptionsPanel.setBorder(BorderFactory.createTitledBorder(this.messages.get("DATABASE_OPTIONS")));
        JPanel mediumSearchPanel = new JPanel();
        mediumSearchPanel.setBorder(BorderFactory.createTitledBorder(this.messages.get("MEDIUM_SEARCH")));
        JPanel machinePanel = new JPanel();
        machinePanel.setBorder(BorderFactory.createTitledBorder(this.messages.get("MACHINE")));
        GroupLayout gl_contentPanel = new GroupLayout(contentPanel);
        gl_contentPanel.setHorizontalGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_contentPanel.createSequentialGroup().addContainerGap().addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(databaseOptionsPanel, GroupLayout.Alignment.LEADING, -1, 481, Short.MAX_VALUE).addComponent(machinePanel, GroupLayout.Alignment.LEADING, -1, 481, Short.MAX_VALUE).addComponent(directoriesPanel, GroupLayout.Alignment.LEADING, -1, 481, Short.MAX_VALUE).addComponent(mediumSearchPanel, GroupLayout.Alignment.LEADING, -1, 481, Short.MAX_VALUE)).addContainerGap()));
        gl_contentPanel.setVerticalGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addContainerGap().addComponent(directoriesPanel, -2, 133, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(databaseOptionsPanel, -1, 204, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(mediumSearchPanel, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(machinePanel, -2, -1, -2)));
        this.directoriesListModel = new DefaultListModel();
        this.directoriesList = new JList<Object>(this.directoriesListModel);
        this.addDirectoryButton = new JButton(this.messages.get("ADD"));
        this.addDirectoryButton.addActionListener(this);
        this.removeDirectoryButton = new JButton(this.messages.get("REMOVE"));
        this.removeDirectoryButton.addActionListener(this);
        this.searchSubdirectoriesCheckBox = new JCheckBox(this.messages.get("SEARCH_SUB_DIRECTORIES"));
        this.searchSubdirectoriesCheckBox.setSelected(true);
        GroupLayout gl_panel = new GroupLayout(directoriesPanel);
        gl_panel.setHorizontalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addGap(85).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.searchSubdirectoriesCheckBox).addGroup(gl_panel.createSequentialGroup().addComponent(this.directoriesList, -2, 283, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.addDirectoryButton, -1, -1, Short.MAX_VALUE).addComponent(this.removeDirectoryButton, -1, 79, Short.MAX_VALUE)))).addContainerGap(28, Short.MAX_VALUE)));
        gl_panel.setVerticalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addGap(3).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.directoriesList, -2, 55, -2).addGroup(gl_panel.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addDirectoryButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.removeDirectoryButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 15, Short.MAX_VALUE).addComponent(this.searchSubdirectoriesCheckBox)));
        directoriesPanel.setLayout(gl_panel);
        this.addModeLabel = new JLabel(this.messages.get("ADD_MODE"));
        JLabel lblProfileNameIn = new JLabel(this.messages.get("PROFILE_NAME"));
        this.existingDatabaseRadioButton = new JRadioButton(this.messages.get("EXISTING"));
        this.existingDatabaseRadioButton.addActionListener(this);
        this.newDatabaseRadioButton = new JRadioButton(this.messages.get("NEW"));
        this.newDatabaseRadioButton.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.existingDatabaseRadioButton);
        buttonGroup.add(this.newDatabaseRadioButton);
        this.existingDatabasesComboBox = new JComboBox<String>(Utils.getSortedCaseInsensitiveArray(this.databases));
        this.newDatabaseTextField = new JTextField();
        this.newDatabaseTextField.setColumns(10);
        String[] addModes = new String[]{this.messages.get("APPEND_TO_DATABASE"), this.messages.get("OVERWRITE_DATABASE")};
        this.addModesComboBox = new JComboBox<String>(addModes);
        String[] profileNames = new String[]{this.messages.get("USE_FILENAME"), this.messages.get("USE_COMMON_NAME")};
        this.profileNamesComboBox = new JComboBox<String>(profileNames);
        this.backupDatabaseCheckBox = new JCheckBox(this.messages.get("BACKUP_EXISTING_DATABASE"));
        GroupLayout gl_panel_2 = new GroupLayout(databaseOptionsPanel);
        gl_panel_2.setHorizontalGroup(gl_panel_2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel_2.createSequentialGroup().addGap(92).addComponent(this.existingDatabaseRadioButton).addGap(65).addComponent(this.existingDatabasesComboBox, -2, 233, -2)).addGroup(gl_panel_2.createSequentialGroup().addGap(125).addComponent(this.addModeLabel).addGap(15).addComponent(this.addModesComboBox, -2, 220, -2)).addGroup(gl_panel_2.createSequentialGroup().addGap(127).addComponent(this.backupDatabaseCheckBox)).addGroup(gl_panel_2.createSequentialGroup().addGap(92).addComponent(this.newDatabaseRadioButton).addGap(81).addComponent(this.newDatabaseTextField, -2, 233, -2)).addGroup(gl_panel_2.createSequentialGroup().addGap(92).addComponent(lblProfileNameIn, -2, 94, -2).addGap(34).addComponent(this.profileNamesComboBox, -2, 233, -2)));
        gl_panel_2.setVerticalGroup(gl_panel_2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel_2.createSequentialGroup().addGap(11).addGroup(gl_panel_2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.existingDatabaseRadioButton).addGroup(gl_panel_2.createSequentialGroup().addGap(1).addComponent(this.existingDatabasesComboBox, -2, -1, -2))).addGap(11).addGroup(gl_panel_2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel_2.createSequentialGroup().addGap(3).addComponent(this.addModeLabel)).addComponent(this.addModesComboBox, -2, -1, -2)).addGap(6).addComponent(this.backupDatabaseCheckBox).addGap(11).addGroup(gl_panel_2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.newDatabaseRadioButton).addGroup(gl_panel_2.createSequentialGroup().addGap(1).addComponent(this.newDatabaseTextField, -2, -1, -2))).addGap(14).addGroup(gl_panel_2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel_2.createSequentialGroup().addGap(3).addComponent(lblProfileNameIn)).addComponent(this.profileNamesComboBox, -2, -1, -2))));
        databaseOptionsPanel.setLayout(gl_panel_2);
        this.searchROMCheckBox = new JCheckBox(this.messages.get("ROM"), true);
        this.searchROMCheckBox.addActionListener(this);
        this.searchDiskCheckBox = new JCheckBox(this.messages.get("DISK"), true);
        this.searchDiskCheckBox.addActionListener(this);
        this.searchTapeCheckBox = new JCheckBox(this.messages.get("TAPE"), true);
        this.searchTapeCheckBox.addActionListener(this);
        this.searchLaserdiscCheckBox = new JCheckBox(this.messages.get("LASERDISC"), true);
        this.searchLaserdiscCheckBox.addActionListener(this);
        GroupLayout gl_panel_3 = new GroupLayout(mediumSearchPanel);
        gl_panel_3.setHorizontalGroup(gl_panel_3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel_3.createSequentialGroup().addGap(87).addComponent(this.searchROMCheckBox).addGap(22).addComponent(this.searchDiskCheckBox).addGap(22).addComponent(this.searchTapeCheckBox).addGap(22).addComponent(this.searchLaserdiscCheckBox).addContainerGap(128, Short.MAX_VALUE)));
        gl_panel_3.setVerticalGroup(gl_panel_3.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_panel_3.createSequentialGroup().addContainerGap(15, Short.MAX_VALUE).addGroup(gl_panel_3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchROMCheckBox).addComponent(this.searchDiskCheckBox).addComponent(this.searchTapeCheckBox).addComponent(this.searchLaserdiscCheckBox)).addContainerGap()));
        mediumSearchPanel.setLayout(gl_panel_3);
        this.machinesComboBox = new JComboBox<String>(Utils.getSortedCaseInsensitiveArray(this.machines));
        GroupLayout gl_panel_4 = new GroupLayout(machinePanel);
        gl_panel_4.setHorizontalGroup(gl_panel_4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel_4.createSequentialGroup().addGap(93).addComponent(this.machinesComboBox, -2, 261, -2).addContainerGap(127, Short.MAX_VALUE)));
        gl_panel_4.setVerticalGroup(gl_panel_4.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_panel_4.createSequentialGroup().addContainerGap(5, Short.MAX_VALUE).addComponent(this.machinesComboBox, -2, -1, -2).addContainerGap()));
        machinePanel.setLayout(gl_panel_4);
        JPanel buttonPanel = new JPanel();
        contentPanel.setLayout(gl_contentPanel);
        this.getContentPane().add((Component)buttonPanel, "South");
        buttonPanel.setLayout(new FlowLayout(1, 8, 8));
        this.okButton = new JButton(this.messages.get("OK"));
        this.okButton.addActionListener(this);
        this.okButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        this.okButton.setEnabled(false);
        buttonPanel.add(this.okButton);
        this.cancelButton = new JButton(this.messages.get("CANCEL"));
        this.cancelButton.addActionListener(this);
        this.cancelButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        buttonPanel.add(this.cancelButton);
        this.getRootPane().setDefaultButton(this.cancelButton);
        if (this.databases.isEmpty()) {
            this.newDatabaseRadioButton.setSelected(true);
            this.existingDatabaseRadioButton.setEnabled(false);
            this.addModeLabel.setEnabled(false);
            this.addModesComboBox.setEnabled(false);
            this.existingDatabasesComboBox.setEnabled(false);
            this.backupDatabaseCheckBox.setEnabled(false);
        } else {
            this.existingDatabaseRadioButton.setSelected(true);
            this.newDatabaseTextField.setEnabled(false);
            if (this.currentDatabase == null) {
                this.existingDatabasesComboBox.setSelectedItem(this.databases.iterator().next());
            } else {
                this.existingDatabasesComboBox.setSelectedItem(this.currentDatabase);
            }
        }
        if (this.rightToLeft) {
            directoriesPanel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            databaseOptionsPanel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            mediumSearchPanel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            machinePanel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            buttonPanel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.searchSubdirectoriesCheckBox.setHorizontalTextPosition(10);
            this.existingDatabaseRadioButton.setHorizontalTextPosition(10);
            this.newDatabaseRadioButton.setHorizontalTextPosition(10);
            this.backupDatabaseCheckBox.setHorizontalTextPosition(10);
            this.searchROMCheckBox.setHorizontalTextPosition(10);
            this.searchDiskCheckBox.setHorizontalTextPosition(10);
            this.searchTapeCheckBox.setHorizontalTextPosition(10);
            this.searchLaserdiscCheckBox.setHorizontalTextPosition(10);
            DefaultListCellRenderer renderer = new DefaultListCellRenderer();
            renderer.setHorizontalAlignment(4);
            this.addModesComboBox.setRenderer(renderer);
            this.profileNamesComboBox.setRenderer(renderer);
        }
        this.pack();
        this.setLocationRelativeTo(this.mainWindow);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.startScan();
        } else if (source == this.cancelButton) {
            this.dispose();
        } else if (source == this.addDirectoryButton) {
            JFileChooser chooser = new JFileChooser(previousSelectedDirectory);
            chooser.setFileSelectionMode(1);
            chooser.setAcceptAllFileFilterUsed(false);
            if (chooser.showOpenDialog(this) == 0) {
                File selectedFile = chooser.getSelectedFile();
                this.directoriesListModel.addElement(selectedFile);
                previousSelectedDirectory = selectedFile;
            }
            this.enableOrDisableOKButton();
        } else if (source == this.removeDirectoryButton) {
            int selectedIndex = this.directoriesList.getSelectedIndex();
            if (selectedIndex > -1) {
                this.directoriesListModel.remove(selectedIndex);
            }
            this.enableOrDisableOKButton();
        } else if (source == this.existingDatabaseRadioButton) {
            this.addModeLabel.setEnabled(true);
            this.addModesComboBox.setEnabled(true);
            this.existingDatabasesComboBox.setEnabled(true);
            this.backupDatabaseCheckBox.setEnabled(true);
            this.newDatabaseTextField.setEnabled(false);
        } else if (source == this.newDatabaseRadioButton) {
            this.addModeLabel.setEnabled(false);
            this.addModesComboBox.setEnabled(false);
            this.existingDatabasesComboBox.setEnabled(false);
            this.backupDatabaseCheckBox.setEnabled(false);
            this.newDatabaseTextField.setEnabled(true);
        } else if (source == this.searchROMCheckBox || source.equals(this.searchDiskCheckBox) || source == this.searchTapeCheckBox || source == this.searchLaserdiscCheckBox) {
            this.enableOrDisableOKButton();
        }
    }

    private String[] getAllPaths() {
        int size = this.directoriesListModel.getSize();
        String[] paths = new String[size];
        for (int index = 0; index < size; ++index) {
            paths[index] = this.directoriesListModel.getElementAt(index).toString();
        }
        return paths;
    }

    private String getDatabase() {
        if (this.existingDatabaseRadioButton.isSelected()) {
            return this.existingDatabasesComboBox.getSelectedItem().toString();
        }
        return this.newDatabaseTextField.getText();
    }

    private void enableOrDisableOKButton() {
        if (this.directoriesListModel.isEmpty() || !this.searchROMCheckBox.isSelected() && !this.searchDiskCheckBox.isSelected() && !this.searchTapeCheckBox.isSelected() && !this.searchLaserdiscCheckBox.isSelected()) {
            this.okButton.setEnabled(false);
        } else {
            this.okButton.setEnabled(true);
        }
    }

    private void startScan() {
        FillDatabaseTask fillDatabaseTask = new FillDatabaseTask(new FillDatabaseTaskExecutorImpl(), this.mainWindow, this.messages, this.rightToLeft);
        ProgressWindow progressWindow = new ProgressWindow(fillDatabaseTask, this.language, this.rightToLeft, this);
        progressWindow.showProgress();
        if (!fillDatabaseTask.isError()) {
            try {
                this.presenter.onViewUpdatedDatabase(this.getDatabase());
            }
            catch (LauncherException le) {
                MessageBoxUtil.showErrorMessageBox(this.mainWindow, le, this.messages, this.rightToLeft);
            }
            this.dispose();
            MessageBoxUtil.showInformationMessageBox(this.mainWindow, this.messages.get("TOTAL_ADDED_TO_DATABASE") + ": " + fillDatabaseTask.getResult(), this.messages, this.rightToLeft);
        }
    }

    private class FillDatabaseTaskExecutorImpl
    implements FillDatabaseTaskExecutor {
        private FillDatabaseTaskExecutorImpl() {
        }

        @Override
        public int execute() throws LauncherException {
            return FillDatabaseWindow.this.presenter.onRequestFillDatabaseAction(FillDatabaseWindow.this.getAllPaths(), FillDatabaseWindow.this.searchSubdirectoriesCheckBox.isSelected(), FillDatabaseWindow.this.getDatabase(), FillDatabaseWindow.this.newDatabaseRadioButton.isSelected(), FillDatabaseWindow.this.addModesComboBox.getSelectedIndex() == 0, FillDatabaseWindow.this.machinesComboBox.getSelectedItem().toString(), FillDatabaseWindow.this.searchROMCheckBox.isSelected(), FillDatabaseWindow.this.searchDiskCheckBox.isSelected(), FillDatabaseWindow.this.searchTapeCheckBox.isSelected(), FillDatabaseWindow.this.searchLaserdiscCheckBox.isSelected(), FillDatabaseWindow.this.profileNamesComboBox.getSelectedIndex() == 1, FillDatabaseWindow.this.backupDatabaseCheckBox.isSelected());
        }

        @Override
        public void interrupt() {
            FillDatabaseWindow.this.presenter.onRequestInterruptFillDatabaseProcess();
        }
    }
}

